#!/usr/bin/env ruby

comments = ARGV[0]

if /[a-zA-Z0-9]/ !~ comments
  raise "You must include a comment with your commit."
end

if /refs|fixes|closes\s#([0-9]+)/ !~ comments
  raise "You must reference a Redmine issue in your commit comments (e.g. 'refs #1234')."
end

issue_number = comments[/#([0-9]+)/][/([0-9]+)/]

# Change the username, password, hostname, and dbname in the following line
#    to match your settings
command_line_output = `/usr/bin/mysql -N -u your_mysql_username -pyour_password \
    -h mysql.yourhostname.com your_redmine_dbname -e \
    "SELECT COUNT(*) FROM issues I INNER JOIN issue_statuses S \
    ON S.id = I.status_id WHERE S.is_closed = 0 AND I.id = #{issue_number};"`

redmine_issue_open = command_line_output[0,1]
if '0' == redmine_issue_open
  raise "Issue ##{issue_number} is not in an open state."
end